/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.goldenDB.interceptor;

import com.goldendb.jdbc.StatementImpl;
import com.goldendb.jdbc.internal.core.loadbalance.MultiHostMySQLConnection;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import java.sql.Connection;
import java.sql.SQLException;

public class PreparedStatementInteceptor {
    public static void onStart(String sql, Integer connectionId) {
        try {
            ConnectionStats connectionStats;
            if (connectionId != null && (connectionStats = MysqlCollector.onConnectionStart((Integer)connectionId, (String)sql)) != null) {
                MysqlCollector.onStart((String)sql, (Integer)connectionId);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public static void onError(String sql, Throwable e) {
        try {
            MysqlCollector.onConnectionException((Throwable)e, (String)sql);
            MysqlCollector.onThrowable((Throwable)e);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public static Integer getConnectionId(StatementImpl preparedStatement) throws SQLException {
        Connection connection = preparedStatement.getConnection();
        if (connection instanceof MultiHostMySQLConnection) {
            connection = ((MultiHostMySQLConnection)connection).getActiveMySQLConnection();
        }
        if (connection != null && connection instanceof TransformAccess) {
            Integer id = (Integer)((TransformAccess)connection).getLopsAttribute();
            return id;
        }
        return null;
    }
}

