/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.utils;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetworkUtil {
    private static List<String> allNetworkIps = null;
    private static final Logger LOG = LogFactory.getLogger();
    static String realIp = null;
    static String realName = null;

    public static List<String> getAllNetworkIp() {
        if (allNetworkIps != null) {
            return allNetworkIps;
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            if (netInterfaces == null) {
                return result;
            }
            InetAddress ip = null;
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                String networkName = ni.getName();
                Enumeration<InetAddress> nii = ni.getInetAddresses();
                while (nii.hasMoreElements()) {
                    ip = nii.nextElement();
                    String s = ip.getHostAddress();
                    NetworkUtil.getEthIP(networkName, result, s, ip);
                }
            }
        }
        catch (SocketException e) {
            LOG.log(Level.SEVERE, "failed to get host ip address", (Throwable)e);
        }
        if (realIp != null) {
            result.add(0, realIp);
        }
        if (result.size() > 0) {
            allNetworkIps = result;
        }
        return allNetworkIps;
    }

    private static synchronized void getEthIP(String networkName, List<String> result, String s, InetAddress ip) {
        if (ip.getHostAddress().indexOf(":") == -1 && !s.startsWith("127.")) {
            if (networkName != null && networkName.indexOf("eth") > -1) {
                if (realName == null) {
                    realName = networkName;
                    realIp = s;
                } else if (networkName.compareTo(realName) < 0) {
                    result.add(realIp);
                    realName = networkName;
                    realIp = s;
                } else {
                    result.add(s);
                }
            } else {
                result.add(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostName() {
        String host = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            host = ia.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (StringUtils.isBlank(host) || "localhost".equals(host)) {
            BufferedReader stdInput = null;
            try {
                Process hostname = Runtime.getRuntime().exec("hostname");
                stdInput = new BufferedReader(new InputStreamReader(hostname.getInputStream()));
                String s = stdInput.readLine();
                if (s != null) {
                    String string = host = s;
                    return string;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (stdInput != null) {
                        stdInput.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return host;
    }
}

