/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import com.lubanops.apm.plugin.hbase.HBaseUtils;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hbase.client.ClusterConnection;

public class HBaseClusterStats
extends DefaultSectionStats {
    private final AtomicReference<String> lastError = new AtomicReference();
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();
    private static final String CACHED_SERVER = "cachedServers";
    private static final String ZK_NODES = "zkNodes";
    private ClusterConnection connection;

    public ClusterConnection getConnection() {
        return this.connection;
    }

    public void setConnection(ClusterConnection connection) {
        this.connection = connection;
    }

    public void onError(String errorTraceId) {
        this.onError();
        this.setErrorTraceId(errorTraceId);
    }

    public void setSlowTraceId(String slowTraceId) {
        if (slowTraceId != null) {
            this.slowTraceId.set(slowTraceId);
        }
    }

    public void setErrorTraceId(String errorTraceId) {
        if (this.errorTraceId.get() == null && errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"lastError", (Object)this.lastError.get());
        row.put((Object)"slowTraceId", (Object)this.slowTraceId.get());
        row.put((Object)"errorTraceId", (Object)this.errorTraceId.get());
        if (this.connection != null) {
            String cachedServers = HBaseUtils.getCachedNodesFromConnection(this.connection);
            String zkNodes = HBaseUtils.getZkAddressesFromConnection(this.connection);
            row.put((Object)CACHED_SERVER, (Object)cachedServers);
            row.put((Object)ZK_NODES, (Object)zkNodes);
        }
        return row;
    }

    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (row == null) {
            return null;
        }
        row.put((Object)"lastError", this.lastError.getAndSet(null));
        row.put((Object)"slowTraceId", this.slowTraceId.getAndSet(null));
        row.put((Object)"errorTraceId", this.errorTraceId.getAndSet(null));
        if (this.connection != null) {
            String cachedServers = HBaseUtils.getCachedNodesFromConnection(this.connection);
            String zkNodes = HBaseUtils.getZkAddressesFromConnection(this.connection);
            row.put((Object)CACHED_SERVER, (Object)cachedServers);
            row.put((Object)ZK_NODES, (Object)zkNodes);
        }
        return row;
    }
}

