/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.hbase.collector.HBaseCollector;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaCache;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnValueFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FilterListBase;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ReadOnlyZKClient;

public final class HBaseUtils {
    public static String getClusterIdFromConnection(ClusterConnection connection) {
        String clusterId = "unknown";
        if (connection instanceof AttributeAccess) {
            clusterId = (String)((AttributeAccess)connection).getLopsFileds()[1];
        }
        return clusterId;
    }

    public static String getCachedNodesFromConnection(ClusterConnection connection) {
        MetaCache cache;
        String res = "unknown";
        if (connection instanceof AttributeAccess && (cache = (MetaCache)((AttributeAccess)connection).getLopsFileds()[0]) instanceof AttributeAccess) {
            Set cachedServers = (Set)((AttributeAccess)cache).getLopsFileds()[0];
            res = HBaseUtils.convertServerNameSet(cachedServers);
        }
        return res;
    }

    public static String getZkAddressesFromConnection(ClusterConnection connection) {
        Object registry;
        String res = "unknown";
        if (connection instanceof AttributeAccess && (registry = ((AttributeAccess)connection).getLopsFileds()[2]) instanceof AttributeAccess) {
            ReadOnlyZKClient zk = (ReadOnlyZKClient)((AttributeAccess)registry).getLopsFileds()[0];
            res = zk.getConnectString();
        }
        return res;
    }

    private static String convertServerNameSet(Set<ServerName> set) {
        StringBuilder builder = new StringBuilder();
        for (ServerName serverName : set) {
            String hostPort = HBaseUtils.parseServerName(serverName);
            if (builder.length() == 0) {
                builder.append(hostPort);
                continue;
            }
            builder.append(",").append(hostPort);
        }
        return builder.toString();
    }

    public static long getCellNumFromMutation(Mutation mutation) {
        int res = 0;
        NavigableMap familyCellMap = mutation.getFamilyCellMap();
        for (List cells : familyCellMap.values()) {
            res += cells.size();
        }
        return res;
    }

    public static String getTableNameWithNamespace(HTable table) {
        return HBaseUtils.getTableNameWithNamespace(table.getName());
    }

    public static String getTableNameWithNamespace(TableName tableName) {
        return tableName.getNameWithNamespaceInclAsString();
    }

    public static String parseRegionLocations(RegionLocations regionLocations) {
        HRegionLocation[] hRegionLocations = regionLocations.getRegionLocations();
        StringBuilder builder = new StringBuilder();
        for (HRegionLocation hRegionLocation : hRegionLocations) {
            String serverName = HBaseUtils.parseServerName(hRegionLocation.getServerName());
            if (builder.length() == 0) {
                builder.append(serverName);
                continue;
            }
            builder.append(", ").append(serverName);
        }
        return builder.toString();
    }

    public static String parseServerName(ServerName serverName) {
        String serverString = serverName.getServerName();
        return serverString.substring(0, serverString.lastIndexOf(44)).replaceFirst(",", ":");
    }

    public static String parseScan(Scan scan) {
        StringBuilder builder = new StringBuilder();
        builder.append("Scan: ");
        builder.append("{");
        HBaseUtils.appendFilter(builder, (Query)scan);
        HBaseUtils.appendCacheBlocks(builder, (Query)scan);
        builder.append("}");
        return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
    }

    public static String parseGet(Get get) {
        StringBuilder builder = new StringBuilder();
        builder.append("Get: ");
        builder.append("{");
        Map familyMap = get.getFamilyMap();
        boolean isFirstAdd = true;
        for (Map.Entry entry : familyMap.entrySet()) {
            if (!isFirstAdd) {
                builder.append(", ");
            }
            byte[] family = (byte[])entry.getKey();
            NavigableSet qualifiers = (NavigableSet)entry.getValue();
            String familyString = Bytes.toString((byte[])family);
            String qualifiersString = HBaseUtils.parseNavigableSet(qualifiers);
            builder.append(familyString);
            builder.append(": [");
            builder.append(qualifiersString);
            builder.append("]");
            if (builder.length() > HBaseCollector.getMaximumVarargsLength()) {
                return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
            }
            isFirstAdd = false;
        }
        HBaseUtils.appendFilter(builder, (Query)get);
        HBaseUtils.appendCacheBlocks(builder, (Query)get);
        builder.append("}");
        return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
    }

    private static void appendFilter(StringBuilder builder, Query query) {
        Filter filter = query.getFilter();
        if (filter != null) {
            if (builder.charAt(builder.length() - 1) != '{') {
                builder.append(", ");
            }
            builder.append(HBaseUtils.parseFilter(filter));
        }
    }

    private static void appendMaxVersions(StringBuilder builder, Query query) {
        if (query instanceof Get) {
            if (builder.charAt(builder.length() - 1) != '{') {
                builder.append(", ");
            }
            builder.append("maxVersions: ");
            builder.append(((Get)query).getMaxVersions());
        } else if (query instanceof Scan) {
            if (builder.charAt(builder.length() - 1) != '{') {
                builder.append(", ");
            }
            builder.append("maxVersions: ");
            builder.append(((Scan)query).getMaxVersions());
        }
    }

    private static void appendCacheBlocks(StringBuilder builder, Query query) {
        if (query instanceof Get) {
            if (builder.charAt(builder.length() - 1) != '{') {
                builder.append(", ");
            }
            builder.append("cacheBlocks: ");
            builder.append(((Get)query).getCacheBlocks());
        } else if (query instanceof Scan) {
            if (builder.charAt(builder.length() - 1) != '{') {
                builder.append(", ");
            }
            builder.append("cacheBlocks: ");
            builder.append(((Scan)query).getCacheBlocks());
        }
    }

    private static String parseNavigableSet(NavigableSet<byte[]> set) {
        StringBuilder builder = new StringBuilder();
        for (byte[] element : set) {
            String qualifier = Bytes.toString((byte[])element);
            if (builder.length() == 0) {
                builder.append(qualifier);
                continue;
            }
            builder.append(", ").append(qualifier);
        }
        return builder.toString();
    }

    public static String parseMutation(Mutation mutation) {
        StringBuilder builder = new StringBuilder();
        builder.append(mutation.getClass().getSimpleName()).append(": ");
        builder.append("{");
        NavigableMap familyCellMap = mutation.getFamilyCellMap();
        boolean isFirstAdd = true;
        for (Map.Entry entry : familyCellMap.entrySet()) {
            if (!isFirstAdd) {
                builder.append(", ");
            }
            byte[] family = (byte[])entry.getKey();
            List cellList = (List)entry.getValue();
            String familyString = Bytes.toString((byte[])family);
            String cellListString = HBaseUtils.parseCellList(cellList);
            builder.append(familyString);
            builder.append(": [");
            builder.append(cellListString);
            builder.append("]");
            if (builder.length() > HBaseCollector.getMaximumVarargsLength()) {
                return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
            }
            isFirstAdd = false;
        }
        builder.append("}");
        return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
    }

    private static String parseCellList(List<Cell> list) {
        StringBuilder builder = new StringBuilder();
        for (Cell cell : list) {
            String qualifier = Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(qualifier).append(": ").append("?");
        }
        return builder.toString();
    }

    public static String parseRowMutations(RowMutations rowMutations) {
        StringBuilder builder = new StringBuilder();
        builder.append("RowMutations: ");
        builder.append("[");
        boolean isFirstAdd = true;
        for (Mutation mutation : rowMutations.getMutations()) {
            if (!isFirstAdd) {
                builder.append(", ");
            }
            builder.append(mutation.getClass().getSimpleName());
            isFirstAdd = false;
        }
        builder.append("]");
        return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
    }

    public static String parseBatchRowList(List<? extends Row> list) {
        StringBuilder builder = new StringBuilder();
        builder.append("batch: ");
        builder.append("[");
        boolean isFirstAdd = true;
        TreeSet<String> set = new TreeSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            Row row = list.get(i);
            set.add(row.getClass().getSimpleName());
        }
        for (String op : set) {
            if (!isFirstAdd) {
                builder.append(", ");
            }
            builder.append(op);
            isFirstAdd = false;
        }
        builder.append("]");
        return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
    }

    public static String parseIncrementColumnValue(String family, String qualifier) {
        return "incrementColumnValue: {family: " + family + ", qualifier: " + qualifier + "}";
    }

    public static String parseCheckAndMutate(String family, String qualifier, CompareOperator op, Filter filter, Mutation mutation) {
        StringBuilder builder = new StringBuilder();
        builder.append("doCheckAnd").append(mutation.getClass().getSimpleName()).append(": ");
        builder.append("{");
        HBaseUtils.addCheckAndMutateCommon(builder, family, qualifier, op, filter);
        builder.append(HBaseUtils.parseMutation(mutation));
        builder.append("}");
        return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
    }

    public static String parseCheckAndMutate(String family, String qualifier, String opName, Mutation mutation) {
        StringBuilder builder = new StringBuilder();
        builder.append("doCheckAnd").append(mutation.getClass().getSimpleName()).append(": ");
        builder.append("{");
        HBaseUtils.addCheckAndMutateCommon(builder, family, qualifier, opName);
        builder.append(HBaseUtils.parseMutation(mutation));
        builder.append("}");
        return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
    }

    public static String parseCheckAndMutations(String family, String qualifier, CompareOperator op, Filter filter, RowMutations mutations) {
        StringBuilder builder = new StringBuilder();
        builder.append("doCheckAnd").append("Mutate").append(": ");
        builder.append("{");
        HBaseUtils.addCheckAndMutateCommon(builder, family, qualifier, op, filter);
        builder.append(HBaseUtils.parseRowMutations(mutations));
        builder.append("}");
        return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
    }

    public static String parseCheckAndMutations(String family, String qualifier, String opName, RowMutations mutations) {
        StringBuilder builder = new StringBuilder();
        builder.append("doCheckAnd").append("Mutate").append(": ");
        builder.append("{");
        HBaseUtils.addCheckAndMutateCommon(builder, family, qualifier, opName);
        builder.append(HBaseUtils.parseRowMutations(mutations));
        builder.append("}");
        return HBaseUtils.truncatedToString(builder, HBaseCollector.getMaximumVarargsLength());
    }

    private static void addCheckAndMutateCommon(StringBuilder builder, String family, String qualifier, CompareOperator op, Filter filter) {
        if (family != null) {
            builder.append("family: ").append(family).append(", ");
        }
        if (qualifier != null) {
            builder.append("qualifier: ").append(qualifier).append(", ");
        }
        if (op != null) {
            builder.append("CompareOperator: ").append(op.toString()).append(", ");
        }
        builder.append("value: ").append("?").append(", ");
        if (filter != null) {
            builder.append("Filter: ").append(filter.getClass().getSimpleName()).append(", ");
        }
    }

    private static void addCheckAndMutateCommon(StringBuilder builder, String family, String qualifier, String opName) {
        if (family != null) {
            builder.append("family: ").append(family).append(", ");
        }
        if (qualifier != null) {
            builder.append("qualifier: ").append(qualifier).append(", ");
        }
        if (opName != null) {
            builder.append("CompareOperator: ").append(opName).append(", ");
        }
        builder.append("value: ").append("?").append(", ");
    }

    private static String truncatedToString(StringBuilder builder, int maxLength) {
        if (builder.length() > maxLength) {
            builder.setLength(maxLength);
            builder.append("...");
        }
        return builder.toString();
    }

    public static String parseFilter(Filter filter) {
        String res = filter instanceof SingleColumnValueFilter ? HBaseUtils.parseSingleColumnValueFilter((SingleColumnValueFilter)filter) : (filter instanceof ColumnValueFilter ? HBaseUtils.parseColumnValueFilter((ColumnValueFilter)filter) : (filter instanceof FilterListBase ? HBaseUtils.parseFilterListBase((FilterListBase)filter) : (filter instanceof FilterList ? HBaseUtils.parseFilterList((FilterList)filter) : filter.getClass().getSimpleName())));
        return res;
    }

    private static String parseSingleColumnValueFilter(SingleColumnValueFilter filter) {
        return filter.getClass().getSimpleName() + ": {family: " + Bytes.toString((byte[])filter.getFamily()) + ", qualifier: " + Bytes.toString((byte[])filter.getQualifier()) + ", compareOperator: " + filter.getCompareOperator().name() + "}";
    }

    private static String parseColumnValueFilter(ColumnValueFilter filter) {
        return filter.getClass().getSimpleName() + ": {family: " + Bytes.toString((byte[])filter.getFamily()) + ", qualifier: " + Bytes.toString((byte[])filter.getQualifier()) + ", compareOperator: " + filter.getCompareOperator().name() + "}";
    }

    private static String parseFilterListBase(FilterListBase filter) {
        return filter.getClass().getSimpleName() + ": {filters: [" + HBaseUtils.parseFilterList(filter.getFilters()) + "]}";
    }

    private static String parseFilterList(FilterList filterList) {
        return filterList.getClass().getSimpleName() + ": {operator: " + filterList.getOperator().name() + ", filters: [" + HBaseUtils.parseFilterList(filterList.getFilters()) + "]}";
    }

    private static String parseFilterList(List<Filter> filterList) {
        StringBuilder builder = new StringBuilder();
        boolean isFirstAdd = true;
        for (Filter filter : filterList) {
            if (!isFirstAdd) {
                builder.append(", ").append(HBaseUtils.parseFilter(filter));
            } else {
                builder.append(HBaseUtils.parseFilter(filter));
            }
            isFirstAdd = false;
        }
        return builder.toString();
    }

    static {
        HBaseCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)HTable.class.getProtectionDomain()));
    }
}

