/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.functiongraph.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.bootstrap.utils.HarvestUtil;
import java.util.concurrent.atomic.AtomicLong;

public class ServerClusterStatsBase
implements StatsBase {
    private volatile long invokeCountOld;
    private volatile long totalTimeOld;
    private volatile long errorCountOld;
    private AtomicLong invokeCount = new AtomicLong();
    private AtomicLong totalTime = new AtomicLong();
    private AtomicLong errorCount = new AtomicLong();

    public MonitorDataRow harvest() {
        MonitorDataRow row = new MonitorDataRow();
        long invokeCountLong = this.invokeCount.get();
        long newInvokeCount = invokeCountLong - this.invokeCountOld;
        if (newInvokeCount > 0L) {
            row.put((Object)"invokeCount", (Object)newInvokeCount);
            this.invokeCountOld = invokeCountLong;
            long newTotalTimeL = this.totalTime.get();
            long totalTimeLong = newTotalTimeL - this.totalTimeOld;
            this.totalTimeOld = newTotalTimeL;
            row.put((Object)"totalTime", (Object)(totalTimeLong / 1000000L));
            this.errorCountOld = HarvestUtil.getMetricCount((AtomicLong)this.errorCount, (long)this.errorCountOld, (String)"errorCount", (MonitorDataRow)row);
            return row;
        }
        return null;
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = new MonitorDataRow();
        row.put((Object)"invokeCount", (Object)this.invokeCount.get());
        row.put((Object)"totalTime", (Object)(this.totalTime.get() / 1000000L));
        row.put((Object)"errorCount", (Object)this.errorCount.get());
        return row;
    }

    public long getErrorCountOld() {
        return this.errorCountOld;
    }

    public AtomicLong getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCountOld(long errorCountOld) {
        this.errorCountOld = errorCountOld;
    }

    public void setErrorCount(AtomicLong errorCount) {
        this.errorCount = errorCount;
    }

    public AtomicLong getInvokeCount() {
        return this.invokeCount;
    }

    public AtomicLong getTotalTime() {
        return this.totalTime;
    }

    public void setInvokeCount(AtomicLong invokeCount) {
        this.invokeCount = invokeCount;
    }

    public void setTotalTime(AtomicLong totalTime) {
        this.totalTime = totalTime;
    }
}

