/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.gaussdb.zenith.interceptor.gaussjdbc200;

import com.huawei.gauss200.jdbc.core.CachedQuery;
import com.huawei.gauss200.jdbc.core.ParameterList;
import com.huawei.gauss200.jdbc.jdbc.PgResultSet;
import com.huawei.gauss200.jdbc.jdbc.PgStatement;
import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.gaussdb.zenith.GaussTrace;
import com.lubanops.apm.plugin.gaussdb.zenith.GaussUtils;
import com.lubanops.apm.plugin.gaussdb.zenith.collector.GaussDbCollector;
import java.util.List;

public class Gauss200StatementExecuteInternalInterceptor
implements Interceptor {
    public Object[] onStart(Object statementObject, Object[] args, String className, String methodName) {
        if (!GaussDbCollector.INSTANCE.isEnable()) {
            return null;
        }
        try {
            CachedQuery cachedQuery = (CachedQuery)args[0];
            Object key = cachedQuery.key;
            String sql = "Unknown";
            if (key instanceof String) {
                sql = (String)key;
            } else if (key instanceof AttributeAccess) {
                sql = String.valueOf(((AttributeAccess)key).getLopsFileds()[0]);
            }
            String originSql = null;
            if (GaussDbCollector.CONFIG.isParseOriginSql()) {
                originSql = cachedQuery.query.toString((ParameterList)args[1]);
            }
            PgStatement statement = (PgStatement)statementObject;
            Integer id = GaussUtils.getConnectionId(statement);
            GaussUtils.onStatementStart(sql, id);
            GaussTrace.onStart(className, methodName, sql, originSql, id);
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.INFO, "StatementExecuteInterceptor onStart error", (Throwable)stmtExecuteException);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (!GaussDbCollector.INSTANCE.isEnable()) {
            return;
        }
        try {
            CachedQuery cachedQuery = (CachedQuery)args[0];
            String sql = cachedQuery.query.getNativeSql();
            GaussUtils.onStatementError(e, sql);
            GaussTrace.onError(e);
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.INFO, "", (Throwable)stmtExecuteException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (!GaussDbCollector.INSTANCE.isEnable()) {
            return;
        }
        try {
            PgStatement statement = (PgStatement)object;
            CachedQuery cachedQuery = (CachedQuery)args[0];
            String sql = cachedQuery.query.getNativeSql();
            int readRowCount = 0;
            int updatedRowCount = statement.getUpdateCount();
            PgResultSet resultSet = (PgResultSet)statement.getResultSet();
            if (resultSet instanceof AttributeAccess) {
                readRowCount = ((List)((AttributeAccess)resultSet).getLopsFileds()[0]).size();
            }
            GaussDbCollector.onConnectionEnd(sql, updatedRowCount, readRowCount);
            GaussDbCollector.onFinally(updatedRowCount, readRowCount);
            GaussTrace.onFinally(updatedRowCount, readRowCount);
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)stmtExecuteException);
        }
    }
}

