/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.util;

import com.huawei.gaussdb.jdbc.core.PGStream;
import com.huawei.gaussdb.jdbc.util.ByteConverter;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ByteConvertUtil {
    private static final byte[] INT_4_BYTES = new byte[4];

    private static byte[] reverse(byte[] bytes) {
        byte[] res = new byte[bytes.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = bytes[res.length - 1 - i];
        }
        return res;
    }

    public static byte[] int4(int value, boolean isBigEnding) {
        ByteConverter.int4(INT_4_BYTES, 0, value);
        return isBigEnding ? INT_4_BYTES : ByteConvertUtil.reverse(INT_4_BYTES);
    }

    public static byte[] int4(int value) {
        return ByteConvertUtil.int4(value, true);
    }

    private static int int4From(InputStream stream) throws IOException {
        return ByteConvertUtil.int4From(stream, true);
    }

    public static int int4From(InputStream stream, boolean isBigEnding) throws IOException {
        int res = stream.read(INT_4_BYTES);
        if (res == -1) {
            throw new EOFException();
        }
        return isBigEnding ? ByteConverter.int4(INT_4_BYTES, 0) : ByteConverter.int4(ByteConvertUtil.reverse(INT_4_BYTES), 0);
    }

    public static char charFrom(InputStream stream) throws IOException {
        int res = stream.read();
        if (res == -1) {
            throw new EOFException();
        }
        return (char)res;
    }

    public static String stringFrom(InputStream stream, int size, boolean shouldRemoveSuffix) throws IOException {
        if (shouldRemoveSuffix) {
            String res;
            int end = (res = ByteConvertUtil.stringFrom(stream, size)).indexOf(0);
            return res.substring(0, end != -1 ? end : res.length());
        }
        return ByteConvertUtil.stringFrom(stream, size);
    }

    public static String removeSuffix(String str) {
        int end = str.indexOf(0);
        return str.substring(0, end != -1 ? end : str.length());
    }

    private static String stringFrom(InputStream stream, int size) throws IOException {
        byte[] byteStr = new byte[size];
        int res = stream.read(byteStr);
        if (res == -1) {
            throw new EOFException();
        }
        return new String(byteStr, StandardCharsets.UTF_8);
    }

    public static byte[] str(String str, int size) {
        byte[] aBytes = str.getBytes(StandardCharsets.UTF_8);
        byte[] res = Arrays.copyOf(aBytes, size);
        if (aBytes.length < size) {
            for (int i = aBytes.length; i < size; ++i) {
                res[i] = 0;
            }
        }
        return res;
    }

    public static int receiveInt4(PGStream pgStream) {
        try {
            byte[] bytes = pgStream.receive(4);
            bytes = ByteConvertUtil.reverse(bytes);
            return ByteConvertUtil.int4From(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            return 0;
        }
    }
}

