/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.tac;

import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTContext;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnection;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionMonitor;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsLockManager;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.FanEventType;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.MasterStatus;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.TaskCnType;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.TaskMasterDnType;
import com.huawei.gaussdb.jdbc.jdbc.alt.exception.ALTException;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.DBConnectionTracker;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.FanDBNodeInfo;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.FanTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacReConnectActuator;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacTracker;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class TacTaskProcessingTask
implements Runnable {
    private static Log LOGGER = Logger.getLogger(TacTaskProcessingTask.class.getName());
    private static final long GNS_WAIT_TIME = 120000L;
    private final GnsConnection gnsConnection;
    private final FanTask task;
    private final String altClusterId;
    private final ALTContext context;
    private final DBConnectionTracker dbConnectionTracker;
    private final TacTracker tacTracker;
    private final GnsConnectionMonitor gnsConnectionMonitor;
    private final GnsLockManager gnsLockManager;

    public TacTaskProcessingTask(FanTask fanTask, ALTContext context) {
        this.task = fanTask;
        this.altClusterId = fanTask.getAltClusterId();
        this.gnsConnection = fanTask.getGnsConnection();
        this.context = context;
        this.dbConnectionTracker = context.getDBConnectionTracker();
        this.tacTracker = context.getTacTracker();
        this.gnsConnectionMonitor = context.getGnsConnectionMonitor();
        this.gnsLockManager = context.getGnsLockManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.gnsLockManager.lock(this.altClusterId);
            LoggerUtil.debug(LOGGER, "Construct TacClusterInfo and wait for transaction drain.");
            this.initTacClusterInfo(this.task.getFanEventType());
            LoggerUtil.debug(LOGGER, "Construct a reconnection list.");
            TacReConnectActuator tacReConnectActuator = this.tacTracker.buildTacReConnectActuator(this.context, this.altClusterId);
            if (this.tacTracker.tacIsTimeOut(this.altClusterId)) {
                this.stopTac(tacReConnectActuator);
                return;
            }
            LoggerUtil.debug(LOGGER, "Send an ACK message.");
            this.gnsConnection.sendAckPacket();
            LoggerUtil.debug(LOGGER, "Waiting for the reconnection flag event");
            long expireTime = System.currentTimeMillis() + 120000L;
            do {
                long currentTime;
                if ((currentTime = System.currentTimeMillis()) < expireTime && this.gnsLockManager.waitOnLock(this.altClusterId, expireTime - currentTime)) continue;
                this.stopTac(tacReConnectActuator);
                return;
            } while (!this.gnsConnectionMonitor.isGnsConnected(this.altClusterId) && !this.tacTracker.tacIsTimeOut(this.altClusterId));
            if (this.tacTracker.tacIsTimeOut(this.altClusterId)) {
                this.stopTac(tacReConnectActuator);
                return;
            }
            this.tacTracker.cleanOldConnections(this.altClusterId);
            tacReConnectActuator.reConnect();
            this.tacTracker.unlockSuspendConn(this.altClusterId);
        }
        catch (IOException e) {
            LoggerUtil.warn(LOGGER, "Fail to send ackMsg to gns");
        }
        catch (ALTException e) {
            LoggerUtil.warn(LOGGER, e.getMessage());
        }
        finally {
            LoggerUtil.debug(LOGGER, "Clean tacClusterInfo");
            this.tacTracker.cleanup(this.task.getAltClusterId());
        }
    }

    private void stopTac(TacReConnectActuator tacReConnectActuator) {
        LoggerUtil.warn(LOGGER, "Timeout when deal with planned FanTask, all db connections will be removed, gns will be disconnected");
        tacReConnectActuator.unlockPgConn();
        this.tacTracker.unlockSuspendConn(this.altClusterId);
        this.dbConnectionTracker.cleanAltClusterInfo(this.altClusterId);
        this.gnsConnectionMonitor.unRegister(this.altClusterId);
    }

    private void initTacClusterInfo(FanEventType fanEventType) throws ALTException {
        Map<HostSpec, FanDBNodeInfo> clusterInfo = this.dbConnectionTracker.findClusterInfo(this.task.getAltClusterId());
        if (clusterInfo == null) {
            throw new ALTException("clusterInfo is empty, altClusterId is " + this.task.getAltClusterId());
        }
        FanDBNodeInfo currentNode = null;
        if (this.task.getRemoteHost() != null && !this.task.getRemoteHost().toString().isEmpty()) {
            currentNode = clusterInfo.get(this.task.getRemoteHost());
        }
        switch (fanEventType) {
            case TAC_SHUT_DOWN_ALL: {
                this.tacTracker.tacShutDownAll(this.task, clusterInfo);
                break;
            }
            case TAC_SHUT_DOWN_NODE: {
                this.checkCurrentNode(currentNode, this.task);
                if (!this.dbConnectionTracker.isAltDist(this.task.getAltClusterId())) {
                    this.tacTracker.tacShutDownNode(this.task, clusterInfo, currentNode);
                    break;
                }
                this.dealTaskType();
                this.tacTracker.tacDistShutDownNode(this.task, clusterInfo, currentNode);
                break;
            }
            case TAC_SHUT_DOWN_DN: {
                if (!this.dbConnectionTracker.isAltDist(this.task.getAltClusterId())) {
                    this.checkCurrentNode(currentNode, this.task);
                    this.tacTracker.tacShutDownDn(this.task, clusterInfo, currentNode);
                    break;
                }
                if (this.task.getPriStatus() != MasterStatus.MASTER_DN_INVALID) break;
                this.tacTracker.tacDistShutDownDnMaster(this.task, clusterInfo);
                break;
            }
            case TAC_SWITCHER_OVER: {
                if (!this.dbConnectionTracker.isAltDist(this.task.getAltClusterId())) {
                    this.tacTracker.tacSwitchoverNode(this.task, clusterInfo);
                    break;
                }
                this.tacTracker.tacDistShutDownDnMaster(this.task, clusterInfo);
                break;
            }
            default: {
                throw new ALTException("UnKnown TAC fan event type : " + (Object)((Object)fanEventType));
            }
        }
    }

    private void checkCurrentNode(FanDBNodeInfo currentNode, FanTask task) throws ALTException {
        if (currentNode == null) {
            throw new ALTException("Can't find " + task.getRemoteHost() + " in clusterInfo");
        }
    }

    private void dealTaskType() {
        List<String> remoteHosts = this.task.getRemoteHosts();
        if (remoteHosts == null || remoteHosts.isEmpty()) {
            this.task.setCnType(TaskCnType.CN_NOT_CLOSED);
        } else {
            this.task.setCnType(TaskCnType.CN_CLOSED);
        }
        if (this.task.getPriStatus() == MasterStatus.MASTER_DN_INVALID) {
            this.task.setTaskMasterDnType(TaskMasterDnType.DN_MASTER_CLOSED);
        } else {
            this.task.setTaskMasterDnType(TaskMasterDnType.DN_MASTER_NOT_CLOSED);
        }
    }

    public String toString() {
        return "TacTaskProcessingTask{altClusterId=" + this.task.getAltClusterId() + ", FanEventType=" + (Object)((Object)this.task.getFanEventType()) + '}';
    }
}

