/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.connection;

import com.huawei.gaussdb.jdbc.PGProperty;
import com.huawei.gaussdb.jdbc.core.SocketFactoryFactory;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnection;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionFactory;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionImpl;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionPropParser;
import com.huawei.gaussdb.jdbc.jdbc.alt.exception.ALTException;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.net.SocketFactory;

public class GnsConnectionFactoryImpl
implements GnsConnectionFactory {
    private static final Log LOGGER = Logger.getLogger(GnsConnectionFactoryImpl.class.getName());

    @Override
    public GnsConnection openGnsConnection(Properties properties, long timeout) throws ALTException {
        SocketFactory socketFactory;
        try {
            socketFactory = SocketFactoryFactory.getSocketFactory(properties);
        }
        catch (PSQLException e) {
            throw new ALTException(e.getMessage(), e.getCause());
        }
        String altClusterId = GnsConnectionPropParser.getAltClusterId(properties);
        List<HostSpec> gnsServers = GnsConnectionPropParser.getGnsHostSpecs(properties);
        if (gnsServers.isEmpty()) {
            throw new ALTException("No gns is available. Check whether " + PGProperty.GNS.get(properties) + " are correct.");
        }
        Collections.shuffle(gnsServers);
        for (HostSpec hostSpec : gnsServers) {
            try {
                LoggerUtil.debug(LOGGER, "Connect to gns:" + hostSpec);
                GnsConnectionImpl connection = new GnsConnectionImpl(altClusterId, hostSpec, properties);
                connection.connect(socketFactory, timeout);
                return connection;
            }
            catch (IOException ace) {
                LoggerUtil.warn(LOGGER, "Can't connect to gns : " + hostSpec);
            }
        }
        throw new ALTException("Could not find a active gns:" + PGProperty.GNS.get(properties));
    }
}

