/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.location;

import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.asm.TryCatchBlock;
import com.alibaba.bytekit.asm.location.Location;
import com.alibaba.bytekit.asm.location.LocationMatcher;
import com.alibaba.bytekit.asm.location.LocationType;
import com.alibaba.bytekit.asm.location.filter.LocationFilter;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.LabelNode;
import java.util.ArrayList;
import java.util.List;

public class ExceptionExitLocationMatcher
implements LocationMatcher {
    private String exception;

    public ExceptionExitLocationMatcher() {
        this(Type.getType(Throwable.class).getInternalName());
    }

    public ExceptionExitLocationMatcher(String exception) {
        this.exception = exception;
    }

    @Override
    public List<Location> match(MethodProcessor methodProcessor) {
        ArrayList<Location> locations = new ArrayList<Location>();
        TryCatchBlock tryCatchBlock = methodProcessor.initTryCatchBlock(this.exception);
        LabelNode endLabelNode = tryCatchBlock.getEndLabelNode();
        LocationFilter locationFilter = methodProcessor.getLocationFilter();
        if (locationFilter.allow((AbstractInsnNode)endLabelNode, LocationType.EXCEPTION_EXIT, false)) {
            locations.add(new Location.ExceptionExitLocation((AbstractInsnNode)tryCatchBlock.getEndLabelNode()));
        }
        return locations;
    }
}

