/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    public static final TimeZone TIMEZONE_SHANGHAI = TimeZone.getTimeZone("Asia/Shanghai");
    public static final Locale LOCALE_SHANGHAI = Locale.SIMPLIFIED_CHINESE;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final TimeUtil SHANGHAI = new TimeUtil(TIMEZONE_SHANGHAI, LOCALE_SHANGHAI);
    private TimeZone timeZone;
    private Locale locale;

    private TimeUtil(TimeZone timeZone, Locale locale) {
        this.timeZone = timeZone;
        this.locale = locale;
    }

    private TimeUtil() {
    }

    public static TimeUtil getDefaultInstance() {
        return SHANGHAI;
    }

    public String formatWithDefault(Date d) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_FORMAT, this.locale);
        return df.format(d);
    }

    public String formatWithDefault(long d) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_FORMAT, this.locale);
        return df.format(d);
    }

    public Date parseWithDefault(String s) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(DEFAULT_FORMAT, this.locale);
            return df.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException("failed to parseWithDefault", e);
        }
    }

    public boolean isStartOfMinute(long timeInMillis) {
        return timeInMillis % 60000L == 0L;
    }

    public long trimToStartOfMinute(long timeInMillis) {
        return timeInMillis / 60000L * 60000L;
    }

    public long trimToEndOfMinute(long timeInMillis) {
        return this.trimToStartOfMinute(timeInMillis) + 60000L;
    }

    public boolean isStartOfHour(long timeInMillis) {
        return timeInMillis % 3600000L == 0L;
    }

    public long trimToStartOfAnHour(long timeInMillis) {
        return timeInMillis / 3600000L * 3600000L;
    }

    public long trimToEndOfAnHour(long timeInMillis) {
        return this.trimToStartOfAnHour(timeInMillis) + 3600000L;
    }

    public boolean isStartOfDay(long timeInMillis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(this.timeZone);
        cal.setTimeInMillis(timeInMillis);
        return cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0;
    }

    public long trimToStartOfADay(long timeInMillis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(this.timeZone);
        cal.setTimeInMillis(timeInMillis);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public long trimToEndOfADay(long timeInMillis) {
        return this.trimToStartOfADay(timeInMillis) + 86400000L;
    }

    public Date parseWithFormat(String s, String format, TimeZone zone) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setTimeZone(zone);
            return sdf.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException("failed to parseWithFormat", e);
        }
    }
}

