/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.message.command;

import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.message.AbstractMessageProvider;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import org.apache.commons.lang3.StringUtils;

public class StackCommand
extends AbstractMessageProvider<StackCommand> {
    @Override
    public Class<StackCommand> getType() {
        return StackCommand.class;
    }

    @Override
    public ArthasDebuggerCommand buildArthasCommand(Requests.Arguments commandArguments) {
        Requests.StackArguments args = (Requests.StackArguments)commandArguments;
        return this.toCommandLine(args);
    }

    private ArthasDebuggerCommand toCommandLine(Requests.StackArguments args) {
        StringBuilder sb = new StringBuilder("stack ");
        if (StringUtils.isBlank((CharSequence)args.getClassPattern())) {
            return new ArthasDebuggerCommand("", "Class pattern must have a value", false);
        }
        sb.append(args.getClassPattern());
        if (StringUtils.isBlank((CharSequence)args.getMethodPattern())) {
            return new ArthasDebuggerCommand("", "Method pattern must have a value", false);
        }
        sb.append(" " + args.getMethodPattern());
        sb.append(" -n 1");
        return new ArthasDebuggerCommand(sb.toString(), "", true);
    }
}

