/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.job;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.lubanops.apm.integration.debugger.converters.SearchClassModelToPDebuggerResponseConverter;
import com.lubanops.apm.integration.debugger.handler.DebuggerCommandHandler;
import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.job.AbstractJob;
import com.lubanops.apm.integration.debugger.service.job.CommandType;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import com.lubanops.apm.integration.debugger.service.message.command.SearchClassCommand;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.SearchClassModel;
import com.taobao.arthas.core.command.model.StatusModel;
import com.taobao.arthas.core.distribution.PackingResultDistributor;
import com.taobao.arthas.core.distribution.impl.PackingResultDistributorImpl;
import com.taobao.arthas.core.shell.session.Session;
import java.util.HashSet;

public class ClassesJob
extends AbstractJob {
    private DebuggerCommandHandler debugCommandHandler;
    private Session session;
    final SearchClassCommand searchClassCommand;
    private static final int LIMIT = 15;

    public ClassesJob(DebuggerCommandHandler debuggerCommandHandler) {
        this.debugCommandHandler = debuggerCommandHandler;
        this.session = this.debugCommandHandler.getSession();
        this.searchClassCommand = new SearchClassCommand();
    }

    @Override
    public CommandType getType() {
        return CommandType.SEARCH_CLASS_COMMAND;
    }

    @Override
    public PDebuggerResponse handleRequest(PDebuggerRequest request) {
        PackingResultDistributorImpl packingResultDistributor = new PackingResultDistributorImpl(this.session);
        boolean expired = false;
        StatusModel statusModel = null;
        HashSet<String> classNames = new HashSet<String>();
        PDebuggerRequest.SearchClassCommand command = request.getPayload().getSearchClassCommand();
        Requests.SearchClassArguments args = new Requests.SearchClassArguments();
        args.setClassPattern(command.getClassPattern());
        args.setField(command.getIsField());
        ArthasDebuggerCommand arthasDebuggerCommand = this.searchClassCommand.buildArthasCommand(args);
        if (!arthasDebuggerCommand.getSuccess().booleanValue()) {
            return ArthasModelToPDebuggerConverter.createFailureResponse(request, new StatusModel(1, arthasDebuggerCommand.getErrorMsg()), false);
        }
        expired = this.debugCommandHandler.handle(arthasDebuggerCommand.getCommand(), (PackingResultDistributor)packingResultDistributor);
        HashSet<SearchClassModel> searchClassModels = new HashSet<SearchClassModel>();
        for (ResultModel resultModel : packingResultDistributor.getResults()) {
            if (resultModel instanceof SearchClassModel) {
                SearchClassModel model = (SearchClassModel)resultModel;
                searchClassModels.add(model);
                classNames.add(model.getClassInfo().getClassInfo());
                continue;
            }
            if (!(resultModel instanceof StatusModel)) continue;
            statusModel = (StatusModel)resultModel;
        }
        if (!command.getIsSingleSc()) {
            args.setLimit(15);
            args.setWildcard(true);
            ArthasDebuggerCommand arthasDebuggerCommand2 = this.searchClassCommand.buildArthasCommand(args);
            if (!arthasDebuggerCommand2.getSuccess().booleanValue()) {
                return ArthasModelToPDebuggerConverter.createFailureResponse(request, new StatusModel(1, arthasDebuggerCommand.getErrorMsg()), false);
            }
            expired = this.debugCommandHandler.handle(arthasDebuggerCommand2.getCommand(), (PackingResultDistributor)packingResultDistributor);
            for (ResultModel result : packingResultDistributor.getResults()) {
                if (result instanceof SearchClassModel) {
                    SearchClassModel model = (SearchClassModel)result;
                    if (classNames.contains(model.getClassInfo().getClassInfo())) continue;
                    searchClassModels.add((SearchClassModel)result);
                    continue;
                }
                if (!(result instanceof StatusModel)) continue;
                statusModel = (StatusModel)result;
            }
        }
        if (searchClassModels.isEmpty()) {
            if (statusModel != null && statusModel.getStatusCode() == 0) {
                statusModel = new StatusModel(-1, "Empty Response");
            }
            return ArthasModelToPDebuggerConverter.createFailureResponse(request, statusModel, expired);
        }
        return SearchClassModelToPDebuggerResponseConverter.convert(searchClassModels, request);
    }

    @Override
    public boolean needReset() {
        return false;
    }
}

