/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.converters;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.lubanops.apm.integration.debugger.converters.ArthasSerializationHelper;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import com.taobao.arthas.core.command.model.WatchModel;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class WatchModelToPDebuggerResponseConverter
extends ArthasModelToPDebuggerConverter {
    private static final String JSON_OBJ_PREFIX = "data.result.";

    public static PDebuggerResponse convert(WatchModel watchModel, PDebuggerRequest request, Requests.WatchDepths watchDepths, int maxIterableElements, int maxStringLength) {
        PDebuggerResponse.WatchResponse watchResponse = WatchModelToPDebuggerResponseConverter.createWatchResponse(watchModel, watchDepths, maxIterableElements, maxStringLength);
        PDebuggerResponse.Payload.Builder payloadBuilder = PDebuggerResponse.Payload.newBuilder().setWatchResponse(watchResponse);
        return WatchModelToPDebuggerResponseConverter.buildPDebuggerResponse(payloadBuilder, request.getPayload().getPayloadMetadata(), request.getMetadata());
    }

    private static String convertObject(String jpath, Object object, int depth, int maxIterableElements, int maxStringLength) {
        ArthasSerializationHelper serializer = new ArthasSerializationHelper();
        return serializer.serializeObject(jpath, object, depth, maxIterableElements, maxStringLength);
    }

    private static String getJsonPathPrefix(String postfix) {
        return JSON_OBJ_PREFIX + postfix;
    }

    private static PDebuggerResponse.WatchResponse createWatchResponse(WatchModel watchModel, Requests.WatchDepths watchDepths, int maxIterableElements, int maxStringLength) {
        int i;
        List instances = (List)watchModel.getValue().getObject();
        List<Object> params = Arrays.asList((Object[])instances.get(0));
        Object returnObject = instances.get(1);
        Object throwException = instances.get(2);
        Object target = instances.get(3);
        PDebuggerResponse.WatchResponse.Builder builder = PDebuggerResponse.WatchResponse.newBuilder().setCost(watchModel.getCost()).setSizeLimit(watchModel.getSizeLimit().intValue()).setType(watchModel.getType()).setAccessPoint(watchModel.getAccessPoint()).setClassName(watchModel.getClassName()).setMethodName(watchModel.getMethodName());
        PDebuggerResponse.WatchResult.Builder watchResultBuilder = PDebuggerResponse.WatchResult.newBuilder();
        if (!ObjectUtils.isEmpty(params)) {
            for (i = 0; i < params.size(); ++i) {
                String jsonParam = WatchModelToPDebuggerResponseConverter.convertObject(WatchModelToPDebuggerResponseConverter.getJsonPathPrefix("params[" + i + "]"), params.get(i), watchDepths.getParams(), maxIterableElements, maxStringLength);
                watchResultBuilder.addParams(jsonParam);
            }
        }
        if (!ObjectUtils.isEmpty(returnObject)) {
            String jsonReturnObj = WatchModelToPDebuggerResponseConverter.convertObject(WatchModelToPDebuggerResponseConverter.getJsonPathPrefix("returnObject"), returnObject, watchDepths.getReturnObj(), maxIterableElements, maxStringLength);
            watchResultBuilder.setReturnObject(jsonReturnObj);
        }
        if (!ObjectUtils.isEmpty(throwException)) {
            String jsonThrowExp = WatchModelToPDebuggerResponseConverter.convertObject(WatchModelToPDebuggerResponseConverter.getJsonPathPrefix("thrownException"), throwException, -1, -1, maxStringLength);
            watchResultBuilder.setThrownException(jsonThrowExp);
        }
        if (!ObjectUtils.isEmpty(target)) {
            String jsonTarget = WatchModelToPDebuggerResponseConverter.convertObject(WatchModelToPDebuggerResponseConverter.getJsonPathPrefix("target"), target, watchDepths.getTarget(), maxIterableElements, maxStringLength);
            watchResultBuilder.setTarget(jsonTarget);
        }
        if (instances.size() > 4) {
            for (i = 4; i < instances.size(); ++i) {
                String jpathRoot = WatchModelToPDebuggerResponseConverter.getJsonPathPrefix("expression[" + (i - 4) + "]");
                String jsonValue = WatchModelToPDebuggerResponseConverter.convertObject(jpathRoot, instances.get(i), watchDepths.getExpression(), maxIterableElements, maxStringLength);
                watchResultBuilder.addExpression(jsonValue);
            }
        }
        builder.setResult(watchResultBuilder.build());
        return builder.build();
    }
}

