/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.trace;

import com.lubanops.apm.bootstrap.agent.AgentInfo;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.bootstrap.utils.ThreadUtils;
import io.opentelemetry.api.trace.Span;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class SpanEvent {
    private static Timer timer = new Timer("apm-threadstack-collector", true);
    private String globalTraceId;
    private String globalPath;
    private String traceId;
    private String spanId;
    private String eventId;
    private String sourceEventId;
    private String nextSpanId;
    private String className;
    private String method;
    private String type;
    private String source;
    private String realSource;
    private long startTime;
    private long timeUsed;
    private int childrenEventCount;
    private List<DiscardInfo> discard = new ArrayList<DiscardInfo>();
    private Map<String, DiscardInfo> discardMap = new HashMap<String, DiscardInfo>();
    private long discardSpanEventStartTime;
    private boolean hasError;
    private String errorReasons;
    private boolean isAsync = false;
    private String argument;
    private String groupId;
    private boolean hasDbAction;
    private int code;
    private static final String APM_SAMPLING_POLICY = "apm2PolicyId";
    private Map<String, Object> tags = new LinkedHashMap<String, Object>();
    private SpanEvent rootSpanEvent;
    private SpanEvent parentSpanEvent;
    private AtomicInteger atomicId = new AtomicInteger(0);
    private AtomicInteger nextSpanAtomicId = new AtomicInteger(0);
    private AtomicInteger disableDeep = new AtomicInteger(0);
    private long nanoTime;
    private Long threadId;
    private TimerTask task;
    private String otelTraceId;
    private String otelSpanId;
    private String otelParentSpanId;
    private Span otelSpan;

    public void clean() {
        this.setGlobalTraceId(null);
        this.setGlobalPath(null);
        this.setTraceId(null);
        this.setSpanId(null);
        this.setEventId(null);
        this.setNextSpanId(null);
        this.setClassName(null);
        this.setMethod(null);
        this.setType(null);
        this.setStartTime(0L);
        this.setTimeUsed(0L);
        this.setChildrenEventCount(0);
        this.setHasError(false);
        this.setErrorReasons(null);
        this.setSource(null);
        this.setRealSource(null);
        this.setAsync(false);
        this.setCode(0);
        this.setArgument(null);
        this.setSourceEventId(null);
        this.tags.clear();
        this.discardMap.clear();
        this.discard.clear();
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.atomicId.set(0);
        this.nextSpanAtomicId.set(0);
        this.disableDeep.set(0);
        this.setRoot(null);
        this.setParent(null);
        this.setOtelSpan(null);
    }

    public SpanEvent() {
    }

    public SpanEvent(String traceId, String spanId, String domainId) {
        this.init(traceId, spanId, domainId);
    }

    public void init(String traceId, String spanId, String domainId) {
        if (StringUtils.isBlank(traceId) || "null".equals(traceId) || StringUtils.isBlank(spanId) || "null".equals(spanId) || !String.valueOf(IdentityConfigManager.getDomainId()).equals(domainId)) {
            traceId = AgentInfo.generateTraceId();
            spanId = "1";
        }
        this.setEventId("1");
        this.setTraceId(traceId);
        this.setSpanId(spanId);
    }

    public final void init(SpanEvent parent) {
        this.parentSpanEvent = parent;
        this.rootSpanEvent = parent.getRoot() == null ? parent : parent.getRoot();
        this.setTraceId(parent.getTraceId());
        this.setSpanId(parent.getSpanId());
        this.setEventId(parent.getChildSpanEventId());
    }

    public SpanEvent(SpanEvent parent) {
        this.init(parent);
        if (parent.hasSamplingPolicy()) {
            this.setSamplingPolicy((String)parent.getTags().get(APM_SAMPLING_POLICY));
        }
    }

    public boolean isRootSpan() {
        return this.getEventId().equals("1") && this.getSpanId().equals("1");
    }

    public void setSamplingPolicy(String policyId) {
        this.addTag(APM_SAMPLING_POLICY, policyId);
    }

    public boolean hasSamplingPolicy() {
        return this.tags.containsKey(APM_SAMPLING_POLICY);
    }

    public String getPolicyId() {
        return (String)this.tags.get(APM_SAMPLING_POLICY);
    }

    public String getChildSpanEventId() {
        StringBuilder spanEventId = new StringBuilder();
        spanEventId.append(this.getEventId()).append("-").append(this.atomicId.incrementAndGet());
        ++this.childrenEventCount;
        return spanEventId.toString();
    }

    public String generateNextSpanId() {
        if (this.rootSpanEvent == null) {
            StringBuilder nextSpanId = new StringBuilder();
            nextSpanId.append(this.getSpanId()).append("-").append(this.nextSpanAtomicId.incrementAndGet());
            String result = nextSpanId.toString();
            return result;
        }
        String result = this.rootSpanEvent.generateNextSpanId();
        this.setNextSpanId(result);
        if (result.length() > 500) {
            return "";
        }
        return result;
    }

    public SpanEvent getRoot() {
        return this.rootSpanEvent;
    }

    public void setRoot(SpanEvent rootSpanEvent) {
        this.rootSpanEvent = rootSpanEvent;
    }

    public void setSpanError(boolean hasError) {
        if (this.rootSpanEvent != null) {
            this.rootSpanEvent.setHasError(hasError);
        }
        this.setHasError(hasError);
    }

    public long getStartNanoTime() {
        return this.nanoTime;
    }

    public void setStartNanoTime(long nanoTime) {
        this.nanoTime = nanoTime;
    }

    public SpanEvent getParent() {
        return this.parentSpanEvent;
    }

    public void setParent(SpanEvent parentSpanEvent) {
        this.parentSpanEvent = parentSpanEvent;
    }

    public int getChildSpanEventCount() {
        return this.atomicId.get();
    }

    public int getDisableDeep() {
        return this.disableDeep.get();
    }

    public void addDisableDeep() {
        this.disableDeep.incrementAndGet();
    }

    public void subDisableDeep() {
        this.disableDeep.decrementAndGet();
    }

    public void addTag(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.tags.put(key, value);
    }

    public void addMysqlResultTag(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        this.tags.put(key, value);
    }

    public void addTag(String key, String value, int limit) {
        if (key == null || value == null) {
            return;
        }
        value = StringUtils.stringTruncat(value, limit, "...");
        this.tags.put(key, value);
    }

    public void setGlobalTraceId(String globalTraceId) {
        this.globalTraceId = globalTraceId;
    }

    public String getGlobalTraceId() {
        return this.globalTraceId;
    }

    public void setGlobalPath(String globalPath) {
        this.globalPath = globalPath;
    }

    public String getGlobalPath() {
        return this.globalPath;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setNextSpanId(String nextSpanId) {
        this.nextSpanId = nextSpanId;
    }

    public String getNextSpanId() {
        return this.nextSpanId;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getTimeUsed() {
        return this.timeUsed;
    }

    public void setTimeUsed(long timeUsed) {
        this.timeUsed = timeUsed / 1000000L;
    }

    public int getChildrenEventCount() {
        return this.childrenEventCount;
    }

    public void setChildrenEventCount(int childrenEventCount) {
        this.childrenEventCount = childrenEventCount;
    }

    public boolean getHasError() {
        return this.hasError;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public String getErrorReasons() {
        return this.errorReasons;
    }

    public void setErrorReasons(String errorReasons) {
        this.errorReasons = errorReasons;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setRealSource(String realSource) {
        this.realSource = realSource;
    }

    public String getRealSource() {
        return this.realSource;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean async) {
        this.isAsync = async;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean isHasDbAction() {
        return this.hasDbAction;
    }

    public void setHasDbAction(boolean hasDbAction) {
        this.hasDbAction = hasDbAction;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public SpanEvent getRootSpanEvent() {
        return this.rootSpanEvent;
    }

    public void setRootSpanEvent(SpanEvent rootSpanEvent) {
        this.rootSpanEvent = rootSpanEvent;
    }

    public SpanEvent getParentSpanEvent() {
        return this.parentSpanEvent;
    }

    public void setParentSpanEvent(SpanEvent parentSpanEvent) {
        this.parentSpanEvent = parentSpanEvent;
    }

    public AtomicInteger getAtomicId() {
        return this.atomicId;
    }

    public void setAtomicId(AtomicInteger atomicId) {
        this.atomicId = atomicId;
    }

    public AtomicInteger getNextSpanAtomicId() {
        return this.nextSpanAtomicId;
    }

    public void setNextSpanAtomicId(AtomicInteger nextSpanAtomicId) {
        this.nextSpanAtomicId = nextSpanAtomicId;
    }

    public long getNanoTime() {
        return this.nanoTime;
    }

    public void setNanoTime(long nanoTime) {
        this.nanoTime = nanoTime;
    }

    public String getArgument() {
        return this.argument;
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public String getSourceEventId() {
        return this.sourceEventId;
    }

    public void setSourceEventId(String sourceEventId) {
        this.sourceEventId = sourceEventId;
    }

    public Map<String, DiscardInfo> getDiscardMap() {
        return this.discardMap;
    }

    public void setDiscardMap(Map<String, DiscardInfo> discardMap) {
        this.discardMap = discardMap;
    }

    public List<DiscardInfo> getDiscard() {
        return this.discard;
    }

    public void setDiscard(List<DiscardInfo> discard) {
        this.discard = discard;
    }

    public String getOtelTraceId() {
        return this.otelTraceId;
    }

    public void setOtelTraceId(String otelTraceId) {
        this.otelTraceId = otelTraceId;
    }

    public String getOtelSpanId() {
        return this.otelSpanId;
    }

    public void setOtelSpanId(String otelSpanId) {
        this.otelSpanId = otelSpanId;
    }

    public String getOtelParentSpanId() {
        return this.otelParentSpanId;
    }

    public void setOtelParentSpanId(String otelParentSpanId) {
        this.otelParentSpanId = otelParentSpanId;
    }

    public Span getOtelSpan() {
        return this.otelSpan;
    }

    public void setOtelSpan(Span otelSpan) {
        this.otelSpan = otelSpan;
    }

    public long getDiscardSpanEventStartTime() {
        return this.discardSpanEventStartTime;
    }

    public void setDiscardSpanEventStartTime(long discardSpanEventStartTime) {
        this.discardSpanEventStartTime = discardSpanEventStartTime;
    }

    public void setDiscardInfo() {
        this.discard = new ArrayList<DiscardInfo>(this.discardMap.values());
    }

    public Long threadId() {
        return this.threadId;
    }

    public void setThreadId(final Long newThreadId) {
        if (ConfigManager.getStackThreshold() > 0) {
            if ("ASYNC_THREAD".equals(this.type)) {
                return;
            }
            this.threadId = newThreadId;
            if (this.threadId == null) {
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
            } else {
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        int maxFrames;
                        ThreadInfo info;
                        if (SpanEvent.this.threadId != null && (info = ThreadUtils.getThreadInfo(newThreadId, maxFrames = 32)) != null) {
                            SpanEvent.this.tags.put("ThreadStack", ThreadUtils.getThreadInfoString(info, maxFrames));
                        }
                    }
                };
                timer.schedule(this.task, new Date(this.startTime + (long)ConfigManager.getStackThreshold()));
            }
        }
    }

    public static class DiscardInfo {
        private String type;
        private int count;
        private long totalTime;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public void setTotalTime(long totalTime) {
            this.totalTime = totalTime;
        }
    }
}

