/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common.url;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class UrlStats
extends DefaultSectionStats {
    public volatile boolean has200 = false;
    private AtomicReference<String> maxTimeUsedUrl = new AtomicReference();
    private volatile int isRoot = 1;
    private AtomicInteger sampleCount = new AtomicInteger(0);
    private AtomicInteger satisfiedCount = new AtomicInteger(0);
    private AtomicInteger toleratingCount = new AtomicInteger(0);
    private AtomicInteger slowCount = new AtomicInteger(0);
    private int threshold = 200;

    public long onFinally(long start, String nativeUrl, boolean isError, boolean hasException) {
        long timeInMills;
        long endTime = System.nanoTime();
        long useTime = endTime - start;
        boolean isMaxTime = super.onFinallyWithBucket(useTime);
        if (isMaxTime) {
            this.maxTimeUsedUrl.set(nativeUrl);
        }
        if (isError) {
            this.errorCountIncrement();
        }
        if (hasException) {
            this.exceptionCountIncrement();
        }
        if ((timeInMills = useTime / 1000000L) <= (long)this.threshold) {
            this.satisfiedCount.incrementAndGet();
        } else if (timeInMills <= (long)(this.threshold * 4)) {
            this.toleratingCount.incrementAndGet();
        } else {
            this.slowCount.incrementAndGet();
        }
        return useTime;
    }

    private void errorCountIncrement() {
        this.errorCount.incrementAndGet();
    }

    private void exceptionCountIncrement() {
        this.exceptionCount.incrementAndGet();
    }

    public String harvestMaxTimeNativeUrl() {
        return this.maxTimeUsedUrl.getAndSet(null);
    }

    public void runningCountDecrement() {
        this.runningCount.decrementAndGet();
    }

    @Override
    public MonitorDataRow harvest(int[] newRanges) {
        this.sampleCount.set(0);
        MonitorDataRow result = super.harvest(newRanges);
        if (result != null) {
            result.put("isRoot", this.isRoot);
            result.put("satisfiedCount", this.satisfiedCount.getAndSet(0));
            result.put("toleratingCount", this.toleratingCount.getAndSet(0));
            result.put("slowCount", this.slowCount.getAndSet(0));
        }
        return result;
    }

    public AtomicInteger getSampleCount() {
        return this.sampleCount;
    }

    public long getInvokeCount() {
        return this.invokeCount.get() - this.invokeCountOld;
    }

    public int getIsRoot() {
        return this.isRoot;
    }

    public void setIsRoot(String envId) {
        if (this.isRoot == 1 && !StringUtils.isBlank(envId)) {
            this.isRoot = 0;
        }
    }

    public AtomicInteger getSatisfiedCount() {
        return this.satisfiedCount;
    }

    public void setSatisfiedCount(AtomicInteger satisfiedCount) {
        this.satisfiedCount = satisfiedCount;
    }

    public AtomicInteger getToleratingCount() {
        return this.toleratingCount;
    }

    public void setToleratingCount(AtomicInteger toleratingCount) {
        this.toleratingCount = toleratingCount;
    }

    public AtomicInteger getSlowCount() {
        return this.slowCount;
    }

    public void setSlowCount(AtomicInteger slowCount) {
        this.slowCount = slowCount;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

