/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common;

import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultStats;
import com.lubanops.apm.bootstrap.utils.HarvestUtil;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultSectionStats
extends DefaultStats {
    private static final String STATS_PERFORMANCE_RANGES = "ranges";
    private static final int STATS_PERFORMANCE_RANGES_LEANGTH = 5;
    protected final AtomicLong range1 = new AtomicLong(0L);
    protected final AtomicLong range2 = new AtomicLong(0L);
    protected final AtomicLong range3 = new AtomicLong(0L);
    protected final AtomicLong range4 = new AtomicLong(0L);
    protected final AtomicLong range5 = new AtomicLong(0L);
    protected final AtomicLong range6 = new AtomicLong(0L);
    protected final AtomicReference<int[]> rangesAtomic = new AtomicReference<int[]>(new int[]{10, 100, 500, 1000, 10000});
    protected final AtomicLong bucketRange0 = new AtomicLong(0L);
    protected final AtomicLong bucketRange1 = new AtomicLong(0L);
    protected final AtomicLong bucketRange2 = new AtomicLong(0L);
    protected final AtomicLong bucketRange3 = new AtomicLong(0L);
    protected final AtomicLong bucketRange4 = new AtomicLong(0L);
    protected final AtomicLong bucketRange5 = new AtomicLong(0L);
    protected final AtomicLong bucketRange6 = new AtomicLong(0L);
    protected final AtomicLong bucketRange7 = new AtomicLong(0L);
    protected final AtomicLong bucketRange8 = new AtomicLong(0L);
    protected final AtomicLong bucketRange9 = new AtomicLong(0L);
    protected final AtomicLong bucketRange10 = new AtomicLong(0L);
    protected final AtomicLong bucketRange11 = new AtomicLong(0L);
    protected final AtomicLong bucketRange12 = new AtomicLong(0L);
    protected final AtomicLong bucketRange13 = new AtomicLong(0L);
    protected final AtomicLong bucketRange14 = new AtomicLong(0L);
    protected final AtomicReference<int[]> bucketRangesAtomic = new AtomicReference<int[]>(new int[]{5, 10, 25, 50, 75, 100, 250, 500, 750, 1000, 2500, 5000, 7500, 10000});
    private volatile long range1Old;
    private volatile long range2Old;
    private volatile long range3Old;
    private volatile long range4Old;
    private volatile long range5Old;
    private volatile long range6Old;
    private volatile long bucketRange0Old;
    private volatile long bucketRange1Old;
    private volatile long bucketRange2Old;
    private volatile long bucketRange3Old;
    private volatile long bucketRange4Old;
    private volatile long bucketRange5Old;
    private volatile long bucketRange6Old;
    private volatile long bucketRange7Old;
    private volatile long bucketRange8Old;
    private volatile long bucketRange9Old;
    private volatile long bucketRange10Old;
    private volatile long bucketRange11Old;
    private volatile long bucketRange12Old;
    private volatile long bucketRange13Old;
    private volatile long bucketRange14Old;

    protected static void merge(MonitorDataRow dataRowFrom, MonitorDataRow dataRowDes) {
        DefaultStats.merge(dataRowFrom, dataRowDes);
        dataRowDes.put("range1", dataRowDes.get("range1") == null ? (Long)dataRowFrom.get("range1") : (Long)dataRowDes.get("range1") + (Long)dataRowFrom.get("range1"));
        dataRowDes.put("range2", dataRowDes.get("range2") == null ? (Long)dataRowFrom.get("range2") : (Long)dataRowDes.get("range2") + (Long)dataRowFrom.get("range2"));
        dataRowDes.put("range3", dataRowDes.get("range3") == null ? (Long)dataRowFrom.get("range3") : (Long)dataRowDes.get("range3") + (Long)dataRowFrom.get("range3"));
        dataRowDes.put("range4", dataRowDes.get("range4") == null ? (Long)dataRowFrom.get("range4") : (Long)dataRowDes.get("range4") + (Long)dataRowFrom.get("range4"));
        dataRowDes.put("range5", dataRowDes.get("range5") == null ? (Long)dataRowFrom.get("range5") : (Long)dataRowDes.get("range5") + (Long)dataRowFrom.get("range5"));
        dataRowDes.put("range6", dataRowDes.get("range6") == null ? (Long)dataRowFrom.get("range6") : (Long)dataRowDes.get("range6") + (Long)dataRowFrom.get("range6"));
    }

    public void initRanges(int[] newRanges) {
        if (newRanges != null && newRanges.length == 5) {
            this.rangesAtomic.set(newRanges);
            this.reset();
        }
    }

    public void parseRange(Map<String, String> parameters) {
        int[] newRanges;
        String newRangesStr = parameters.get(STATS_PERFORMANCE_RANGES);
        if (!StringUtils.isBlank(newRangesStr) && null != (newRanges = APIService.getJsonApi().parseIntArray(newRangesStr)) && newRanges.length == 5) {
            this.initRanges(newRanges);
        }
    }

    @Override
    public boolean onFinally(long timeInNanos) {
        boolean flag = super.onFinally(timeInNanos);
        this.getRanges(timeInNanos);
        return flag;
    }

    public boolean onFinallyWithBucket(long timeInNanos) {
        boolean flag = super.onFinally(timeInNanos);
        this.getRanges(timeInNanos);
        this.getBucketRanges(timeInNanos);
        return flag;
    }

    @Override
    public boolean onFinallyNoRunningCount(long timeInNanos) {
        boolean flag = super.onFinallyNoRunningCount(timeInNanos);
        this.getRanges(timeInNanos);
        return flag;
    }

    private void getRanges(long timeInNanos) {
        long timeInMills = timeInNanos / 1000000L;
        int[] ranges = this.rangesAtomic.get();
        if (timeInMills < (long)ranges[0]) {
            this.range1.incrementAndGet();
        } else if (timeInMills < (long)ranges[1]) {
            this.range2.incrementAndGet();
        } else if (timeInMills < (long)ranges[2]) {
            this.range3.incrementAndGet();
        } else if (timeInMills < (long)ranges[3]) {
            this.range4.incrementAndGet();
        } else if (timeInMills < (long)ranges[4]) {
            this.range5.incrementAndGet();
        } else {
            this.range6.incrementAndGet();
        }
    }

    private void getBucketRanges(long timeInNanos) {
        long timeInMills = timeInNanos / 1000000L;
        int[] ranges = this.bucketRangesAtomic.get();
        this.bucketRange14.incrementAndGet();
        if (timeInMills > (long)ranges[13]) {
            return;
        }
        this.bucketRange13.incrementAndGet();
        if (timeInMills > (long)ranges[12]) {
            return;
        }
        this.bucketRange12.incrementAndGet();
        if (timeInMills > (long)ranges[11]) {
            return;
        }
        this.bucketRange11.incrementAndGet();
        if (timeInMills > (long)ranges[10]) {
            return;
        }
        this.bucketRange10.incrementAndGet();
        if (timeInMills > (long)ranges[9]) {
            return;
        }
        this.bucketRange9.incrementAndGet();
        if (timeInMills > (long)ranges[8]) {
            return;
        }
        this.bucketRange8.incrementAndGet();
        if (timeInMills > (long)ranges[7]) {
            return;
        }
        this.bucketRange7.incrementAndGet();
        if (timeInMills > (long)ranges[6]) {
            return;
        }
        this.bucketRange6.incrementAndGet();
        if (timeInMills > (long)ranges[5]) {
            return;
        }
        this.bucketRange5.incrementAndGet();
        if (timeInMills > (long)ranges[4]) {
            return;
        }
        this.bucketRange4.incrementAndGet();
        if (timeInMills > (long)ranges[3]) {
            return;
        }
        this.bucketRange3.incrementAndGet();
        if (timeInMills > (long)ranges[2]) {
            return;
        }
        this.bucketRange2.incrementAndGet();
        if (timeInMills > (long)ranges[1]) {
            return;
        }
        this.bucketRange1.incrementAndGet();
        if (timeInMills > (long)ranges[0]) {
            return;
        }
        this.bucketRange0.incrementAndGet();
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put("range1", this.range1.get());
        row.put("range2", this.range2.get());
        row.put("range3", this.range3.get());
        row.put("range4", this.range4.get());
        row.put("range5", this.range5.get());
        row.put("range6", this.range6.get());
        row.put(STATS_PERFORMANCE_RANGES, APIService.getJsonApi().toJSONString(this.rangesAtomic.get()));
        return row;
    }

    public MonitorDataRow getStatusWithBucket() {
        MonitorDataRow row = super.getStatus();
        row.put("range1", this.range1.get());
        row.put("range2", this.range2.get());
        row.put("range3", this.range3.get());
        row.put("range4", this.range4.get());
        row.put("range5", this.range5.get());
        row.put("range6", this.range6.get());
        row.put(STATS_PERFORMANCE_RANGES, APIService.getJsonApi().toJSONString(this.rangesAtomic.get()));
        row.put("bucket_le_5", this.bucketRange0.get());
        row.put("bucket_le_10", this.bucketRange1.get());
        row.put("bucket_le_25", this.bucketRange2.get());
        row.put("bucket_le_50", this.bucketRange3.get());
        row.put("bucket_le_75", this.bucketRange4.get());
        row.put("bucket_le_100", this.bucketRange5.get());
        row.put("bucket_le_250", this.bucketRange6.get());
        row.put("bucket_le_500", this.bucketRange7.get());
        row.put("bucket_le_750", this.bucketRange8.get());
        row.put("bucket_le_1000", this.bucketRange9.get());
        row.put("bucket_le_2500", this.bucketRange10.get());
        row.put("bucket_le_5000", this.bucketRange11.get());
        row.put("bucket_le_7500", this.bucketRange12.get());
        row.put("bucket_le_10000", this.bucketRange13.get());
        row.put("bucket_le_Inf", this.bucketRange14.get());
        return row;
    }

    @Override
    public MonitorDataRow harvest() {
        return this.harvest(null);
    }

    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row;
        int[] oldRanges = this.rangesAtomic.get();
        if (newRanges != null && newRanges.length == 5) {
            this.rangesAtomic.compareAndSet(oldRanges, newRanges);
        }
        if ((row = super.harvest()) != null) {
            this.range1Old = HarvestUtil.getMetricCount(this.range1, this.range1Old, "range1", row);
            this.range2Old = HarvestUtil.getMetricCount(this.range2, this.range2Old, "range2", row);
            this.range3Old = HarvestUtil.getMetricCount(this.range3, this.range3Old, "range3", row);
            this.range4Old = HarvestUtil.getMetricCount(this.range4, this.range4Old, "range4", row);
            this.range5Old = HarvestUtil.getMetricCount(this.range5, this.range5Old, "range5", row);
            this.range6Old = HarvestUtil.getMetricCount(this.range6, this.range6Old, "range6", row);
            row.put(STATS_PERFORMANCE_RANGES, APIService.getJsonApi().toJSONString(oldRanges));
        }
        this.harvestWithBucket(row);
        return row;
    }

    public MonitorDataRow harvestWithBucket(MonitorDataRow row) {
        if (row != null) {
            this.bucketRange0Old = HarvestUtil.getMetricCount(this.bucketRange0, this.bucketRange0Old, "bucket_le_5", row);
            this.bucketRange1Old = HarvestUtil.getMetricCount(this.bucketRange1, this.bucketRange1Old, "bucket_le_10", row);
            this.bucketRange2Old = HarvestUtil.getMetricCount(this.bucketRange2, this.bucketRange2Old, "bucket_le_25", row);
            this.bucketRange3Old = HarvestUtil.getMetricCount(this.bucketRange3, this.bucketRange3Old, "bucket_le_50", row);
            this.bucketRange4Old = HarvestUtil.getMetricCount(this.bucketRange4, this.bucketRange4Old, "bucket_le_75", row);
            this.bucketRange5Old = HarvestUtil.getMetricCount(this.bucketRange5, this.bucketRange5Old, "bucket_le_100", row);
            this.bucketRange6Old = HarvestUtil.getMetricCount(this.bucketRange6, this.bucketRange6Old, "bucket_le_250", row);
            this.bucketRange7Old = HarvestUtil.getMetricCount(this.bucketRange7, this.bucketRange7Old, "bucket_le_500", row);
            this.bucketRange8Old = HarvestUtil.getMetricCount(this.bucketRange8, this.bucketRange8Old, "bucket_le_750", row);
            this.bucketRange9Old = HarvestUtil.getMetricCount(this.bucketRange9, this.bucketRange9Old, "bucket_le_1000", row);
            this.bucketRange10Old = HarvestUtil.getMetricCount(this.bucketRange10, this.bucketRange10Old, "bucket_le_2500", row);
            this.bucketRange11Old = HarvestUtil.getMetricCount(this.bucketRange11, this.bucketRange11Old, "bucket_le_5000", row);
            this.bucketRange12Old = HarvestUtil.getMetricCount(this.bucketRange12, this.bucketRange12Old, "bucket_le_7500", row);
            this.bucketRange13Old = HarvestUtil.getMetricCount(this.bucketRange13, this.bucketRange13Old, "bucket_le_10000", row);
            this.bucketRange14Old = HarvestUtil.getMetricCount(this.bucketRange14, this.bucketRange14Old, "bucket_le_Inf", row);
        }
        return row;
    }

    private void reset() {
        this.range1.getAndSet(0L);
        this.range2.getAndSet(0L);
        this.range3.getAndSet(0L);
        this.range4.getAndSet(0L);
        this.range5.getAndSet(0L);
        this.range6.getAndSet(0L);
        this.range1Old = 0L;
        this.range2Old = 0L;
        this.range3Old = 0L;
        this.range4Old = 0L;
        this.range5Old = 0L;
        this.range6Old = 0L;
        this.bucketRange0Old = 0L;
        this.bucketRange1Old = 0L;
        this.bucketRange2Old = 0L;
        this.bucketRange3Old = 0L;
        this.bucketRange4Old = 0L;
        this.bucketRange5Old = 0L;
        this.bucketRange6Old = 0L;
        this.bucketRange7Old = 0L;
        this.bucketRange8Old = 0L;
        this.bucketRange0.getAndSet(0L);
        this.bucketRange1.getAndSet(0L);
        this.bucketRange2.getAndSet(0L);
        this.bucketRange3.getAndSet(0L);
        this.bucketRange4.getAndSet(0L);
        this.bucketRange5.getAndSet(0L);
        this.bucketRange6.getAndSet(0L);
        this.bucketRange7.getAndSet(0L);
        this.bucketRange8.getAndSet(0L);
        this.bucketRange9.getAndSet(0L);
        this.bucketRange10.getAndSet(0L);
        this.bucketRange11.getAndSet(0L);
        this.bucketRange12.getAndSet(0L);
        this.bucketRange13.getAndSet(0L);
        this.bucketRange14.getAndSet(0L);
    }
}

