/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rocketmq.RocketMqContext;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.consumer.RocketMqSampleFilter;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqConsumerCollector;
import java.util.List;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.hook.ConsumeMessageContext;
import org.apache.rocketmq.client.hook.ConsumeMessageHook;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.common.message.MessageQueue;

public class TracingConsumeMessageHookImp
implements ConsumeMessageHook {
    public static final TracingConsumeMessageHookImp HOOK = new TracingConsumeMessageHookImp();
    private static final String HOOK_NAME = "LubanConsumeMessageTraceHook";
    private static final String CONSUMER_CLASS_NAME = "org/apache/rocketmq/client/consumer/listener/MessageListenerConcurrently";
    private static final String CONSUMER_METHOD_NAME = "consumeMessage";

    public String hookName() {
        return HOOK_NAME;
    }

    public void consumeMessageBefore(ConsumeMessageContext context) {
        try {
            if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty()) {
                return;
            }
            if (RocketMqConsumerCollector.INSTANCE.isEnable()) {
                RocketMqContext.IS_IN_CONSUME_LOCAL.set(Boolean.TRUE);
                DefaultMQPushConsumerImpl consumerImp = (DefaultMQPushConsumerImpl)TransformAccessUtils.getFromLopsAttributeMap((Object)context, (String)"consumerImp");
                Object[] attributes = ((AttributeAccess)consumerImp).getLopsFileds();
                DefaultMQPushConsumer consumer = (DefaultMQPushConsumer)attributes[0];
                MessageListener listener = (MessageListener)attributes[2];
                StartTraceRequest startTraceRequest = new StartTraceRequest(CONSUMER_CLASS_NAME, CONSUMER_METHOD_NAME, null, null, null);
                String url = listener.getClass().getName() + "#" + CONSUMER_METHOD_NAME;
                startTraceRequest.setRealSource(url);
                startTraceRequest.setSource(url);
                startTraceRequest.setKind("RocketMqConsumer");
                startTraceRequest.setSampleFilter((SampleFilter)new RocketMqSampleFilter());
                SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                String clientId = RocketMqUtils.getClientId(consumerImp);
                String group = consumer.getConsumerGroup();
                MessageQueue mq = context.getMq();
                RocketMqConsumerCollector.onPushConsumeStart(url, clientId, group, mq);
                TracingConsumeMessageHookImp.setSpanTag(spanEvent, context);
            }
        }
        catch (Exception consumeMessageException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)consumeMessageException);
        }
    }

    private static void setSpanTag(SpanEvent spanEvent, ConsumeMessageContext context) {
        if (spanEvent != null) {
            String produceTraceId;
            MessageQueue mq = context.getMq();
            String topic = mq.getTopic();
            String brokerName = mq.getBrokerName();
            int queueId = mq.getQueueId();
            List msgList = context.getMsgList();
            spanEvent.addTag("topic", topic);
            spanEvent.addTag("brokerName", brokerName);
            spanEvent.addTag("brokerAddr", RocketMqUtils.getBrokerAddresses(msgList));
            spanEvent.addTag("queueId", String.valueOf(queueId));
            spanEvent.addTag("queueOffset", RocketMqUtils.getQueueOffsets(msgList));
            spanEvent.addTag("tags", RocketMqUtils.getTags(msgList));
            spanEvent.addTag("messageId", RocketMqUtils.getMsgIds(msgList));
            spanEvent.addTag("msgCount", String.valueOf(RocketMqUtils.getMsgCount(msgList)));
            spanEvent.addTag("msgBytes", String.valueOf(RocketMqUtils.getMsgBytes(msgList)));
            String deliverTimeDiffs = RocketMqUtils.getDeliverTimeDiffs(msgList);
            if (deliverTimeDiffs != null) {
                spanEvent.addTag("storeTimestamp - startDeliverTime", deliverTimeDiffs);
            }
            if ((produceTraceId = RocketMqUtils.getMsgsTraceId(msgList)) != null) {
                spanEvent.addTag("produce-traceid", produceTraceId);
            }
        }
    }

    public void consumeMessageAfter(ConsumeMessageContext context) {
        try {
            if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty()) {
                return;
            }
            if (RocketMqConsumerCollector.INSTANCE.isEnable()) {
                SpanEvent spanEvent;
                String status = context.getStatus();
                boolean isSuccess = context.isSuccess();
                List msgList = context.getMsgList();
                int msgCount = RocketMqUtils.getMsgCount(msgList);
                int msgBytes = RocketMqUtils.getMsgBytes(msgList);
                int reconsumeTimes = RocketMqUtils.getReconsumeTimes(msgList);
                Throwable e = RocketMqContext.CONSUME_EXCEPTION_LOCAL.get();
                if (e != null) {
                    RocketMqConsumerCollector.onException(e);
                    TraceCollector.onError((Throwable)e);
                    isSuccess = false;
                }
                if ((spanEvent = TraceCollector.getSpanEvent()) != null) {
                    spanEvent.addTag("reconsumeTimes", String.valueOf(reconsumeTimes));
                    spanEvent.addTag("status", status);
                    spanEvent.addTag("isSuccess", String.valueOf(isSuccess));
                }
                if (!isSuccess) {
                    String errorTraceId = spanEvent == null ? null : spanEvent.getTraceId();
                    RocketMqConsumerCollector.onPushConsumeError(errorTraceId);
                    if (spanEvent != null) {
                        spanEvent.setSpanError(true);
                    }
                }
                RocketMqConsumerCollector.onPushConsumeFinally(msgCount, msgBytes, reconsumeTimes, !isSuccess);
                TraceCollector.onFinally((int)(isSuccess ? 200 : 500));
                RocketMqContext.IS_IN_CONSUME_LOCAL.remove();
                RocketMqContext.CONSUME_EXCEPTION_LOCAL.remove();
            }
        }
        catch (Exception consumeMessageException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)consumeMessageException);
        }
    }
}

