/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.spring.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.plugin.spring.collector.SpringBeanMethodCollector;
import com.lubanops.apm.plugin.spring.collector.SpringBeanMethodPattern;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.core.type.AnnotationMetadata;

public class ClassPathDefinitionScaanerInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogFactory.getLogger();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (!AgentConfigManager.isTransformSpringBean()) {
            return;
        }
        if (result == null || !(result instanceof Set)) {
            return;
        }
        try {
            Set set = (Set)result;
            block2: for (Object o : set) {
                Set annotationTypes;
                AnnotationMetadata metadata;
                BeanDefinition beanDefinition;
                String[] beanIncludePathList;
                if (!(o instanceof BeanDefinitionHolder)) continue;
                BeanDefinitionHolder beanDefinitionHolder = (BeanDefinitionHolder)o;
                SpringBeanMethodPattern methodPattern = new SpringBeanMethodPattern();
                String beanClassName = beanDefinitionHolder.getBeanDefinition().getBeanClassName();
                String replace = beanClassName.replace(".", "/");
                methodPattern.setClassName(replace);
                SpringBeanMethodCollector instance = SpringBeanMethodCollector.getInstance();
                String[] beanExcludePathList = AgentConfigManager.getSpringBeanExcludePathList();
                if (beanExcludePathList.length > 0) {
                    for (String exclude : beanExcludePathList) {
                        if (beanClassName.startsWith(exclude)) continue block2;
                    }
                }
                if ((beanIncludePathList = AgentConfigManager.getSpringBeanIncludePathList()).length > 0) {
                    for (String include : beanIncludePathList) {
                        if (!beanClassName.startsWith(include)) continue;
                        instance.putMethodPattern(replace, methodPattern);
                        continue block2;
                    }
                }
                if (!((beanDefinition = beanDefinitionHolder.getBeanDefinition()) instanceof AnnotatedBeanDefinition) || (metadata = ((AnnotatedBeanDefinition)beanDefinition).getMetadata()) == null || (annotationTypes = metadata.getAnnotationTypes()) == null || annotationTypes.isEmpty() || !annotationTypes.contains("org.springframework.stereotype.Controller") && !annotationTypes.contains("org.springframework.web.bind.annotation.RestController") && !annotationTypes.contains("org.springframework.stereotype.Service")) continue;
                instance.putMethodPattern(replace, methodPattern);
                LOGGER.warning("==============CLASS PATH SCAN: " + beanClassName);
            }
        }
        catch (Throwable t) {
            LOGGER.warning("AFTER. Caused: classpath");
        }
    }
}

