/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.postgresql.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.postgresql.PgUtils;
import com.lubanops.apm.plugin.postgresql.collector.PgsqlCollector;
import java.security.ProtectionDomain;
import org.postgresql.jdbc.PgConnection;

public class ConnectionInterceptor
implements Interceptor {
    public ConnectionInterceptor() {
        PgsqlCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)PgConnection.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            PgConnection connection = (PgConnection)object;
            String pgDbName = Helper.getDbName((String)PgUtils.getHostPostPair(connection.getQueryExecutor().getHostSpec()), (String)connection.getCatalog());
            Integer id = Helper.CONNECTION_TARGET_MAP.registerResource(pgDbName);
            if (object instanceof TransformAccess) {
                ((TransformAccess)object).setLopsAttribute((Object)id);
            }
            PgsqlCollector.onConnectionCreated(id);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

