/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.jetcd.JetcdConfig;
import com.lubanops.apm.plugin.jetcd.JetcdContext;
import com.lubanops.apm.plugin.jetcd.collector.JetcdCollector;
import com.lubanops.apm.plugin.jetcd.interceptor.JetcdKeepAliveSampleFilter;
import io.etcd.jetcd.api.LeaseKeepAliveResponse;
import io.grpc.stub.StreamObserver;
import java.util.List;

public class KeepAliveOnStreamInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                Object[] attributes = ((AttributeAccess)object).getLopsFileds();
                List observers = (List)attributes[0];
                String url = KeepAliveOnStreamInterceptor.constructUrlFromObservers(observers) + "#" + methodName;
                JetcdCollector.onKeepAliveStart(url);
                SpanEvent preSpanEvent = TraceCollector.getSpanEvent();
                if (preSpanEvent != null) {
                    JetcdContext.SAVED_SPANEVENT_LOCAL.set(preSpanEvent);
                }
                StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, null, null, null);
                startTraceRequest.setRealSource(url);
                startTraceRequest.setSource(url);
                startTraceRequest.setKind("Jetcd");
                startTraceRequest.setSampleFilter((SampleFilter)new JetcdKeepAliveSampleFilter());
                SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                if (args.length >= 1) {
                    if (args[0] instanceof LeaseKeepAliveResponse) {
                        KeepAliveOnStreamInterceptor.addTag4LeaseKeepAliveResponse((LeaseKeepAliveResponse)args[0], spanEvent);
                    } else if (args[0] instanceof Throwable) {
                        TraceCollector.onError((Throwable)((Throwable)args[0]));
                        JetcdCollector.onException((Throwable)args[0]);
                        JetcdContext.HAS_ERROR_LOCAL.set(Boolean.TRUE);
                    }
                }
            }
        }
        catch (Exception keepaliveOnStreamException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)keepaliveOnStreamException);
        }
        return new Object[0];
    }

    private static String constructUrlFromObservers(List<StreamObserver<LeaseKeepAliveResponse>> observers) {
        StringBuilder sb = new StringBuilder();
        int lengthLimit = JetcdConfig.getPrimaryKeyLengthLimit();
        for (StreamObserver<LeaseKeepAliveResponse> observer : observers) {
            String className = observer.getClass().getName();
            sb.append(className);
            if (sb.length() <= lengthLimit) continue;
            sb.setLength(lengthLimit);
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    private static void addTag4LeaseKeepAliveResponse(LeaseKeepAliveResponse response, SpanEvent spanEvent) {
        if (response != null && spanEvent != null) {
            long id = response.getID();
            long ttl = response.getTTL();
            spanEvent.addTag("id", String.valueOf(id));
            spanEvent.addTag("ttl", String.valueOf(ttl));
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                JetcdCollector.onException(e);
                JetcdContext.HAS_ERROR_LOCAL.set(Boolean.TRUE);
            }
        }
        catch (Exception keepaliveOnStreamException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)keepaliveOnStreamException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                boolean isSuccess = !Boolean.TRUE.equals(JetcdContext.HAS_ERROR_LOCAL.get());
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                if (!isSuccess) {
                    JetcdCollector.onKeepAliveError(spanEvent == null ? null : spanEvent.getTraceId());
                }
                JetcdCollector.onKeepAliveFinally();
                TraceCollector.onFinally((int)(isSuccess ? 200 : 500));
                if (JetcdContext.SAVED_SPANEVENT_LOCAL.get() != null) {
                    TraceCollector.setSpanEvent((SpanEvent)JetcdContext.SAVED_SPANEVENT_LOCAL.get());
                }
                JetcdContext.SAVED_SPANEVENT_LOCAL.remove();
                JetcdContext.HAS_ERROR_LOCAL.remove();
            }
        }
        catch (Exception keepaliveOnStreamException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)keepaliveOnStreamException);
        }
    }
}

